<?php
session_start();

// Incluir la configuración
require_once __DIR__ . '/../../config/config.php';

// Incluir el controlador
require_once __DIR__ . '/../../controllers/LoginController.php';

// Crear una instancia del controlador
$controller = new LoginController($pdo);

// Verificar si el usuario está autenticado
$controller->checkAuth();

// Mensaje de bienvenida según el rol
switch ($_SESSION['role']) {
    case 'Superadmin':
        $welcome_message = "Bienvenido, Superadmin " . htmlspecialchars($_SESSION['username']) . "!";
        $content = "Tienes acceso completo al sistema.";
        break;
    case 'Administrador':
        $welcome_message = "Bienvenido, Administrador " . htmlspecialchars($_SESSION['username']) . "!";
        $content = "Puedes gestionar usuarios, reservas y configuraciones.";
        break;
    case 'RollPrimario':
        $welcome_message = "Bienvenido, " . htmlspecialchars($_SESSION['username']) . " (Rol Primario)!";
        $content = "Puedes ver y gestionar tus reservas.";
        break;
    case 'RollSecundario':
        $welcome_message = "Bienvenido, " . htmlspecialchars($_SESSION['username']) . " (Rol Secundario)!";
        $content = "Puedes ver tu perfil y acceder a funciones básicas.";
        break;
    default:
        $_SESSION['error'] = "Rol no válido.";
        header("Location: " . BASE_URL . "views/login/logout.php");
        exit();
}

// Incluir el header
require_once __DIR__ . '/../../templates/header.php';
?>

<div class="row justify-content-center">
    <div class="col-md-6">
        <h2 class="text-center mb-4"><?php echo $welcome_message; ?></h2>
        <p class="text-center"><?php echo $content; ?></p>
    </div>
</div>

<?php
// Incluir el footer
require_once __DIR__ . '/../../templates/footer.php';
?>