<?php
session_start();

// Incluir la configuración
require_once __DIR__ . '/../../config/config.php';

// Incluir el controlador
require_once __DIR__ . '/../../controllers/LoginController.php';

// Crear una instancia del controlador
$controller = new LoginController($pdo);

// Verificar si el usuario está autenticado
$controller->checkAuth();

// Redirigir según el rol del usuario
switch ($_SESSION['role']) {
    case 'Administrador':
        $welcome_message = "Bienvenido, Administrador " . htmlspecialchars($_SESSION['username']) . "!";
        break;
    case 'Recepcionista':
        $welcome_message = "Bienvenido, Recepcionista " . htmlspecialchars($_SESSION['username']) . "!";
        break;
    case 'Cliente':
        $welcome_message = "Bienvenido, Cliente " . htmlspecialchars($_SESSION['username']) . "!";
        break;
    default:
        $_SESSION['error'] = "Rol no válido.";
        header("Location: " . BASE_URL . "views/login/logout.php");
        exit();
}

// Incluir el header
require_once __DIR__ . '/../../templates/header.php';
?>

<div class="row justify-content-center">
    <div class="col-md-6">
        <h2 class="text-center mb-4"><?php echo $welcome_message; ?></h2>
        <p class="text-center">Has iniciado sesión correctamente.</p>
    </div>
</div>

<?php
// Incluir el footer
require_once __DIR__ . '/../../templates/footer.php';
?>