// Configuración de Particles.js para el topbar
document.addEventListener('DOMContentLoaded', function() {
    particlesJS("topbar-particles", {
        "particles": {
            "number": {
                "value": 100, /* Aumentamos de 50 a 100 partículas para un efecto más denso */
                "density": {
                    "enable": true,
                    "value_area": 600 /* Reducimos de 800 a 600 para mayor densidad */
                }
            },
            "color": {
                "value": "#ffffff" /* Partículas blancas puras */
            },
            "shape": {
                "type": "circle",
                "stroke": {
                    "width": 0,
                    "color": "#000000"
                }
            },
            "opacity": {
                "value": 1, /* Máxima opacidad */
                "random": false,
                "anim": {
                    "enable": false, /* Desactivamos animación de opacidad */
                    "speed": 1,
                    "opacity_min": 1, /* Aseguramos que no se desvanezcan */
                    "sync": false
                }
            },
            "size": {
                "value": 7, /* Aumentamos de 5 a 7 para partículas más grandes */
                "random": true,
                "anim": {
                    "enable": false,
                    "speed": 40,
                    "size_min": 0.1,
                    "sync": false
                }
            },
            "line_linked": {
                "enable": true,
                "distance": 80, /* Reducimos de 120 a 80 para más conexiones */
                "color": "#ffffff", /* Líneas blancas puras para máximo contraste */
                "opacity": 1, /* Máxima opacidad */
                "width": 2 /* Aumentamos de 1.5 a 2 para líneas más gruesas */
            },
            "move": {
                "enable": true,
                "speed": 1.5, /* Aumentamos ligeramente de 1 a 1.5 para un movimiento más dinámico */
                "direction": "none",
                "random": false,
                "straight": false,
                "out_mode": "out",
                "bounce": false
            }
        },
        "interactivity": {
            "detect_on": "canvas",
            "events": {
                "onhover": {
                    "enable": true,
                    "mode": "repulse"
                },
                "onclick": {
                    "enable": true,
                    "mode": "push"
                },
                "resize": true
            },
            "modes": {
                "grab": {
                    "distance": 400,
                    "line_linked": {
                        "opacity": 1
                    }
                },
                "bubble": {
                    "distance": 400,
                    "size": 40,
                    "duration": 2,
                    "opacity": 8,
                    "speed": 3
                },
                "repulse": {
                    "distance": 100,
                    "duration": 0.4
                },
                "push": {
                    "particles_nb": 4
                },
                "remove": {
                    "particles_nb": 2
                }
            }
        },
        "retina_detect": true
    });
});